import json
import os
import sys
from xml.etree.ElementTree import ElementTree
import ComputedMetricsSummary
import utility_functions
import logging

    
if __name__ == '__main__':
    debug_log_path = './log/CAD_update_summary_testresults.log'
    if not os.path.exists('./log'):
        os.makedirs('./log')
    else:
        if os.path.exists(debug_log_path):
            os.remove(debug_log_path)
            
    logger = utility_functions.setup_logger(debug_log_path)

    result_json = {}


    if os.path.exists('summary.testresults.json'):
        # read current summary report, which contains the metrics
        with open('summary.testresults.json','r') as file_in:
            result_json = json.load(file_in)

        # update analysis status
        if 'AnalysisStatus' in result_json:
            if os.path.exists('_FAILED.txt'):
                result_json['AnalysisStatus'] = 'FAILED'
            else:
                    result_json['AnalysisStatus'] = 'OK'
        else:
            logger.debug('summary.testresults.json does not contain AnalysisStatus')
        
        metrics_file ='ComputedValues.xml'

        if os.path.exists(metrics_file):            
            ComputedMetricsSummary.ParseXMLFile(metrics_file)
            #print (ComputedMetricsSummary.gMetricSummary)

            if 'Metrics' in result_json:
                for metric in result_json['Metrics']:
                    if 'Name' in metric and 'Value' in metric and 'ID' in metric:
                        key = metric['ID']
                        if ComputedMetricsSummary.gMetricSummary.has_key(key):
                            # update metric's value to the last value in
                            # time series
                            metric['Value'] = ComputedMetricsSummary.gMetricSummary[key][1]
                            metric['Unit'] = ComputedMetricsSummary.gMetricSummary[key][0]
                            logger.debug('Metric: {0} {1} {2} was updated.'.format(metric['Name'],
                                                                                   metric['Value'],
                                                                                   metric['Unit']))

                        else:
                            # metric was not found in results
                            logger.debug('ComputedMetrics.xml key error: {0}'.format(key))
            else:
                # create warning message
                logger.debug('summary.testresults.json does not contain Metrics')
        else:
            logger.debug('Given result file does not exist: {0}'.format(metrics_file))

        # update json file with the new values
        with open('summary.testresults.json','wb') as file_out:
            json.dump(result_json, file_out, indent=4)
        logger.debug('Finished updating summary.testresults.json file.')
        
    else:
        logger.debug('summary.testresults.json does not exist!')                   



